class twitch::haproxy::video_api_lb(
  $listen_address = '*',
  $listen_port    = 80,
  $stats_port     = 2015,
  $nbproc         = 1,
){

  $instance_name        = 'video_api_lb'

  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => "/var/run/haproxy-${instance_name}.pid",
    'maxconn' => '64000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => $nbproc,
    'log-tag' => "haproxy_${instance_name}",
    'log'     => '127.0.0.1 local3',
  }

  $defaults_options = {
    'log'     => 'global',
    'mode'    => 'tcp',
    'balance' => 'roundrobin',
    'maxconn' => '64000',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
  }

  logrotate::rule { 'haproxy_video_api_lb':
    ensure          => present,
    path            => '/var/log/jtv/haproxy_video_api_lb.log',
    olddir          => '/var/log/archive',
    missingok       => true,
    rotate          => 72,
    rotate_every    => 'hour',
    compress        => true,
    compresscmd     => '/usr/bin/pbzip2',
    compressoptions => '-1p4',
    compressext     => '.bz2',
    sharedscripts   => true,
    create          => false,
    postrotate      => '/usr/local/bin/rsyslog_reopen_logs.sh',
  }

  twitch_haproxy::instance { $instance_name:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    with_consul_template => true,
    create_stats_sockets => true,
  }

  class { 'twitch::haproxy::listeners::backend_video_api_lb':
    haproxy_instance => $instance_name,
    listen_port      => $listen_port,
    listen_address   => $listen_address,
    use_so_reuseport => true,
    nbproc           => $nbproc,
  }

}
