class twitch::haproxy::video_cdncache_ssl (
  $instname               = 'video_cdncache_ssl',
  $stats_port             = 2012,
  $nbproc                 = 16,
  $backend_server_list    = ['127.0.0.1:80'],
  $backend_server_options = 'check',
){
  $global_options = {
    'nbproc'                    => $nbproc,
    'user'                      => 'www-data',
    'group'                     => 'www-data',
    'daemon'                    => '',
    'tune.ssl.default-dh-param' => '2048',
    'ssl-default-bind-ciphers'  => hiera('ciphers::performance'),
    'ssl-default-bind-options'  => 'no-sslv3 no-tls-tickets',
    'tune.ssl.cachesize'        => '80000',
    'tune.ssl.lifetime'         => '14400',
    'log'                       => '127.0.0.1 local3',
    'log-tag'                   => 'haproxy_video_cdncache_ssl',
    'pidfile'                   => '/var/run/haproxy-video_cdncache_ssl.pid'
  }

  $defaults_options = {
    'mode'    => 'http',
    'option'  => ['dontlog-normal','httplog','log-health-checks','http-keep-alive'],
    'timeout' => ['connect 10s','client 10s','server 10s'],
    'log'     => 'global',
  }

  twitch_haproxy::instance { $instname:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    create_stats_sockets => true,
  }

}

