class twitch::haproxy::video_edge_ssl (
  $instname               = 'video_edge_ssl',
  $stats_port             = 2012,
  $nbproc                 = 16,
  $backend_server_list    = ['127.0.0.1:80'],
  $backend_server_options = 'check',
  $http2                  = false,
  $warp_enabled           = false,
){
  $global_options = {
    'nbproc'                    => $nbproc,
    'user'                      => 'www-data',
    'group'                     => 'www-data',
    'daemon'                    => '',
    'tune.ssl.default-dh-param' => '2048',
    'ssl-default-bind-ciphers'  => hiera('ciphers::performance'),
    'ssl-default-bind-options'  => 'no-sslv3',
    'tune.ssl.cachesize'        => '80000',
    'tune.ssl.lifetime'         => '14400',
    'log'                       => '127.0.0.1 local3',
    'log-tag'                   => 'haproxy_video_edge_ssl',
    'pidfile'                   => '/var/run/haproxy-video_edge_ssl.pid'
  }

  $defaults_options = {
    'mode'    => 'http',
    'option'  => ['dontlog-normal','httplog','log-health-checks','http-keep-alive'],
    'timeout' => ['connect 10s','client 10s','server 10s'],
    'log'     => 'global',
  }

  twitch_haproxy::instance { $instname:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    create_stats_sockets => true,
  }

  class { 'twitch::haproxy::frontends::video_edge_ssl':
    instance_name    => $instname,
    default_backend  => 'https-keepalive',
    use_so_reuseport => true,
    nbproc           => $nbproc,
    require          => Twitch_haproxy::Backend['https-keepalive'],
    http2            => $http2,
    warp_enabled     => $warp_enabled,
  }

  twitch_haproxy::backend { 'https-keepalive':
    instance_name       => $instname,
    default_remote_port => 80,
    server_list         => $backend_server_list,
    server_options      => $backend_server_options,
  }

  if ($warp_enabled) {
    twitch_haproxy::backend { 'warp':
      instance_name       => $instname,
      default_remote_port => 9001,
      server_list         => [ '127.0.0.1:9001' ],
      server_options      => 'check',
    }
  }
}

