class twitch::haproxy::video_offnet_origin (
  $instname   = 'video_offnet_origin',
  $stats_port = 2012,
  $nbproc     = 16,
){
  $global_options = {
    'nbproc'                    => $nbproc,
    'user'                      => 'www-data',
    'group'                     => 'www-data',
    'daemon'                    => '',
    'log'                       => '127.0.0.1 local3',
    'log-tag'                   => 'haproxy_video_offnet_origin',
    'pidfile'                   => '/var/run/haproxy-video_offnet_origin.pid'
  }

  $defaults_options = {
    'mode'    => 'tcp',
    'option'  => ['httplog','log-health-checks'],
    'timeout' => ['connect 10s','client 60s','server 60s'],
    'log'     => 'global',
    'log-format' => '%ci:%cp\ [%t]\ %ft\ %b/%s\ %Tq/%Tw/%Tc/%Tr/%Tt\ %ST\ %B\ %CC\ %CS\ %tsc\ %ac/%fc/%bc/%sc/%rc\ %sq/%bq\ %hr\ %hs\ %{+Q}r\ %sslc\ %sslv',
  }

  twitch_haproxy::instance { $instname:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    create_stats_sockets => true,
  }

  class { 'twitch::haproxy::frontends::video_offnet_origin':
    instance_name    => $instname,
    default_backend  => 'pachyderm',
    use_so_reuseport => true,
    nbproc           => $nbproc,
    require          => Twitch_haproxy::Backend['pachyderm'],
  }

  twitch_haproxy::backend { 'pachyderm':
    instance_name       => $instname,
    default_remote_port => 8086,
    server_list         => [
      '127.0.0.1:8086',
    ],
    server_options      => 'check',
    options             => {
      'mode' => 'tcp',
    },
  }
}

