class twitch::haproxy::video_weaver (
  $instance_name           = 'video_weaver',
  $user                    = 'www-data',
  $group                   = 'www-data',
  $stats_port              = 2013,
  $listen_address          = '*',
  $weaver_listen_port      = 8000,
  $weaver_primary_port     = 6000,
  $weaver_backup_port      = 6001,
  $varnish_backend_name    = 'video_varnish_http',
  $varnish_port            = 8080,
  $haproxy_maxconns        = 16000,
){
  $global_options = {
    'user'                      => $user,
    'group'                     => $group,
    'maxconn'                   => $haproxy_maxconns,
    'daemon'                    => '',
    'log'                       => '127.0.0.1 local3',
    'log-tag'                   => "haproxy_${instance_name}",
    'pidfile'                   => "/var/run/haproxy-${instance_name}.pid",
  }

  $defaults_options = {
    'mode'    => 'http',
    'maxconn' => $haproxy_maxconns,
    'log'     => 'global',
    'option'  => [
      'dontlog-normal',
      'httplog',
      'log-health-checks',
    ],
    'timeout' => [
      'connect 2s',
      'client  4s',
      'server  4s'
    ],
  }

  twitch_haproxy::instance { $instance_name:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    create_stats_sockets => true,
  }

  class { 'twitch::haproxy::listeners::video_weaver':
    instance_name       => $instance_name,
    listen_address      => $listen_address,
    listen_port         => $weaver_listen_port,
    remote_port_primary => $weaver_primary_port,
    remote_port_backup  => $weaver_backup_port,
    require             => Twitch_haproxy::Backend[$varnish_backend_name],
  }

  twitch_haproxy::backend { $varnish_backend_name:
    instance_name       => $instance_name,
    default_remote_port => $varnish_port,
    server_list         => [
      "127.0.0.1:${varnish_port}",
    ],
  }
}
