class twitch::haproxy::video_weaver_lb (
  $instance_name  = 'video_weaver_lb',
  $nbproc         = $::processorcount,
  $user           = 'www-data',
  $group          = 'www-data',
  $stats_port     = 2012,
  $listen_address = '*',
  $listen_port    = [80],
  $consul_service = "${twitch_environment}.video-weaver",
){
  $global_options = {
    'nbproc'                    => $nbproc,
    'user'                      => $user,
    'group'                     => $group,
    'maxconn'                   => 8000,
    'daemon'                    => '',
    'tune.ssl.default-dh-param' => '2048',
    'ssl-default-bind-ciphers'  => hiera('ciphers::performance'),
    'ssl-default-bind-options'  => 'no-sslv3',
    'tune.ssl.cachesize'        => '80000',
    'tune.ssl.lifetime'         => '14400',
    'log'                       => '127.0.0.1 local3',
    'log-tag'                   => "haproxy_${instance_name}",
    'pidfile'                   => "/var/run/haproxy-${instance_name}.pid",
  }

  $defaults_options = {
    'mode'    => 'http',
    'maxconn' => 8000,
    'log'     => 'global',
    'option'  => [
      'dontlog-normal',
      'httplog',
      'log-health-checks',
    ],
    'timeout' => [
      'connect 2s',
      'client  4s',
      'server  4s'
    ],
  }

  twitch_haproxy::instance { $instance_name:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    with_consul_template => true,
    create_stats_sockets => true,
  }

  $frontend_options = {
    'mode'            => 'http',
    'monitor-uri'     => '/health',
    'monitor fail'    => 'if no_srv',
    'default_backend' => 'video_weaver',
    'timeout'         => [
      'http-request 10000',
    ],
    'option'          => [
      'http-keep-alive',
      'forwardfor except 127.0.0.0/8 header X-Client-IP',
    ],
    'http-request'    => [
      'del-header X-Client-IP',
    ],
    'acl'             => [
      'no_srv nbsrv(video_weaver) lt 1',
    ],
  }

  twitch_haproxy::frontend{ 'video_weaver_http':
    instance_name    => $instance_name,
    ports            => $listen_port,
    ipaddress        => $listen_address,
    options          => $frontend_options,
    use_so_reuseport => true,
    nbproc           => $nbproc,
    require          => Twitch_haproxy::Consul_backend['video_weaver'],
  }

  class { 'twitch::haproxy::frontends::video_weaver_ssl':
    instance_name    => $instance_name,
    frontend_name    => 'video_weaver_https',
    default_backend  => 'video_weaver',
    use_so_reuseport => true,
    nbproc           => $nbproc,
    require          => Twitch_haproxy::Consul_backend['video_weaver'],
  }

  $backend_options = {
    'mode'    => 'http',
    'balance' => 'roundrobin',
    'option'  => [
      'httpchk HEAD /health',
      'http-keep-alive',
      'prefer-last-server',
    ],
    'timeout' => [
      'http-keep-alive 10000'
    ],
  }

  twitch_haproxy::consul_backend{ 'video_weaver':
    instance_name   => $instance_name,
    consul_services => {
      'service' => $consul_service,
      'health'  => 'passing',
      'options' => 'check inter 1s weight 100 agent-check agent-port 8878 agent-inter 1s',
    },
    options         => $backend_options,
  }
}
