class twitch::haproxy::web (
  $instname   = 'web',
  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => '/var/run/haproxy-web.pid',
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => '2',
    'log-tag' => 'haproxy_web',
    'log'     => '127.0.0.1 local3',
    'stats'   => 'socket /var/run/haproxy_web-private.stat user root group root mode 666 level operator'
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'mode'    => 'tcp',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
    'timeout' => [
      'connect 500',
      'server 30000',
      'client 500'
    ]
  },
  $staging = false,
){
  include twitchtv

  twitch_haproxy::instance { $instname:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    create_stats_sockets => true,
    with_consul_template => true,
  }

  class{ 'twitch::haproxy::web_rails_varnish':
    instance_name => 'web',
    dc            => 'us-west2'
  }

  class{ 'twitch::haproxy::listeners::web_rails_app':
    haproxy_instance => 'web',
    dc               => 'us-west2'
  }
}
