class twitch::haproxy::web_rails_varnish (
  $instance_name,
  $listen_address = '127.0.0.1',
  $listen_port = 6650,
  $proxy_name = 'rails_varnish',
  $consul_target = $twitchtv::consul_deploy_tag,
  $dc = $::pop,
  $server_options = 'check inter 5000',
  $backend_options = {
    'mode' => 'http',
    'balance' => 'uri whole',
    'hash-type' => 'map-based',
    'option' => ['httplog', 'forceclose', 'http-server-close'],
  },
  $frontend_options = {
    'log' => 'global',
    'mode' => 'http',
    'option' => ['httplog', 'dontlog-normal', 'dontlognull', 'forceclose', 'http-server-close'],
  },
) {
  include stdlib

  # The frontend decides which backend to hit.
  # This will go into the haproxy_${instance_name}.conf instead of haproxy_${instance_name}.dynamic.conf.ctmpl
  # TODO: is ^ a problem?
  twitch_haproxy::frontend{ $proxy_name:
    instance_name => $instance_name,
    ports         => $listen_port,
    ipaddress     => $listen_address,
    options       => merge($frontend_options, {
      'acl'             => "primary_is_down nbsrv(${proxy_name}_primary) eq 0",
      'use_backend'     => "${proxy_name}_backup if primary_is_down",
      'default_backend' => "${proxy_name}_primary",
    }),
  }

  # This backend does a deep healthcheck on its servers.
  $healthcheck_options = {option => concat($backend_options['option'], 'httpchk HEAD /running/index HTTP/1.0')}
  twitch_haproxy::consul_backend{ "${proxy_name}_primary":
    instance_name   => $instance_name,
    consul_services => {
      service => "${consul_target}.web-rails-varnish@${dc}",
      health  => 'passing',
      options => $server_options,
    },
    options         => merge($backend_options, $healthcheck_options),
  }

  # This backend is only used if all the servers in the primary backend are unhealthy.
  twitch_haproxy::consul_backend{ "${proxy_name}_backup":
    instance_name   => $instance_name,
    consul_services => {
      service => "${consul_target}.web-rails-varnish@${dc}",
      health  => 'passing',
      options => $server_options,
    },
    options         => $backend_options,
  }
}
