define twitch::local_user(
  $user   = $name,
  $group  = $name,
  $groups = undef,
  $ensure = 'present',
) {

  if $ensure == 'absent' {
    User[$user] -> Group[$group]
  }

  if !defined(Group[$group]) {
    # create local group
    group { $group:
      ensure => $ensure,
      system => true,
    }
  }

  # create a local user, with primary group
  user { $user:
    ensure => $ensure,
    gid    => $group,
    groups => $groups,
    system => true,
  }
}
