class twitch::packages {

  $installed_packages = [
    'automake',
    'bc',
    'bison',
    'build-essential',
    'debconf-utils',
    'flex',
    'fping',
    'graphviz',
    'jq',
    'libcap2-bin',
    'libevent-dev',
    'libfaac0',
    'libffi-dev',
    'libid3tag0',
    'libmp3lame0',
    'libmysqlclient-dev',
    'libpcre3-dev',
    'libreadline-dev',
    'libsasl2-dev',
    'libspeex1',
    'libssl-dev',
    'libtool',
    'libvorbisenc2',
    'libxml2-dev',
    'libxslt1-dev',
    'libyaml-dev',
    'logtail',
    'lzop',
    'maven',
    'pbuilder',
    'pkg-config',
    'python-gevent',
    'python-protobuf',
    'screen',
    'snmp',
    'socat',
    'spawn-fcgi',
    'subversion',
    'swfmill',
    'tmpreaper',
    'tmux',
    'unzip',
    'xfsprogs',
  ]

  @package { $installed_packages:
    ensure  => 'installed',
    tag     => 'virtual',
    require => Exec['apt_update']
  }


  # python packages
  @package { 'mixpanel-py':
    provider => 'twitch_pip',
    tag      => 'virtual',
    require  => Exec['apt_update']
  }
}
