# Twitch params class
class twitch::params {
  $twitch_conf_basedir = '/etc/twitch'

  # root user ssh config options
  $root_ssh_config_default = {
    'Host git.internal.justin.tv' => {
      'User'                      => 'git',
      'IdentityFile'              => '/home/jtv/.ssh/github_rsa'
    },
    'Host *'         => {
      'IdentityFile' => [
        '/home/jtv/.ssh/root_key',
        '/home/jtv/.ssh/id_rsa',
        '/home/jtv/.ssh/identity',
      ]
    }
  }
  case $::ipaddress_primary {
    /^10\./: {
      $root_ssh_config_ipaddress = {
        'Host github.com'  => {
          'User'           => 'git',
          'Port'           => '22',
          'Hostname'       => 'github.com',
          'IdentityFile'   => '/home/jtv/.ssh/github_rsa',
          'TCPKeepAlive'   => 'yes',
          'IdentitiesOnly' => 'yes',
          'ProxyCommand'   => 'connect -4 -S prxy.internal.justin.tv:1080 %h %p',
        }
      }
    }
    default: {
      $root_ssh_config_ipaddress = {
        'Host github.com'  => {
          'User'           => 'git',
          'Port'           => '22',
          'Hostname'       => 'github.com',
          'IdentityFile'   => '/home/jtv/.ssh/github_rsa',
          'TCPKeepAlive'   => 'yes',
          'IdentitiesOnly' => 'yes',
        }
      }
    }
  }
  $root_ssh_config=merge($root_ssh_config_default,$root_ssh_config_ipaddress)

  # jtv user ssh config options
  $jtv_ssh_config = {
    'Host github.com'  => {
      'User'           => 'git',
      'Port'           => '22',
      'Hostname'       => 'github.com',
    'IdentityFile'   => '~/.ssh/github_rsa',
    'TCPKeepAlive'   => 'yes',
    'IdentitiesOnly' => 'yes',
    'ProxyCommand'   => 'connect -4 -S prxy.internal.justin.tv:1080 %h %p',
    },
    'Host brigade2.sfo01.justin.tv brigade.internal.justin.tv' => {
      'User'         => 'jtv',
      'IdentityFile' => '~/.ssh/pull_from_brigade_dsa'
    },
    'Host git.internal.justin.tv' => {
      'User'                      => 'git',
      'Port'                      => '22',
      'Hostname'                  => 'git.internal.justin.tv',
      'IdentityFile'              => '~/.ssh/github_rsa',
      'TCPKeepAlive'              => 'yes',
      'IdentitiesOnly'            => 'yes'
    },
  }
}
