class twitch::sureroute {
  include twitch_nginx
  $html_dir = $twitch_nginx::nginx_html_dir

  file { "${html_dir}/sureroute.html":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/${module_name}/sureroute.html",
    notify  => Class['twitch_nginx::service'],
    require => Class['twitch_nginx::config_dirs']
  }
}
