# manage deploy user
class twitch::users::deploy (
  $password              = undef,
  $ssh_authorized_keys   = [],
  $ssh_authorized_keys_default = [
    'deploy_pubkey',
  ],
  $ssh_priv_keys         = [],
  $ssh_priv_keys_default = [],
  $ssh_config_opts       = {}
) inherits twitch::params {
  validate_array($ssh_authorized_keys, $ssh_priv_keys)
  validate_hash($ssh_config_opts)

  $ssh_authorized_keys_all = flatten([$ssh_authorized_keys_default, $ssh_authorized_keys])
  $ssh_priv_keys_all       = flatten([$ssh_priv_keys_default, $ssh_priv_keys])

  @ssh_authorized_key { 'deploy_pubkey':
    ensure => 'present',
    type   => 'ssh-rsa',
    key    => 'AAAAB3NzaC1yc2EAAAADAQABAAACAQCj4lS0mjSIxVVMkSMvKH1QG6CRqZ2DrdU0OnpvWaLWveMaMT52JNprSErgj/UF8y6Q9+twUJKzfCU8KOEs7mKvgi9iW2vajqitABlulvVkuBmZwE43m7yi2l7vAr8hBUHrILR2GUNjTp4e/yt5fBQw7YkZ2RjzusVrClH1GFfzPOvly0kNmm+ZmMuhS790bqXsVP7AioPVP5Q13seJhjVPxQGkp53bOelCFpVpt7nHZULj+3q7LdU5IcFmDcH33/G/Op9gfe94JfUWp/7fCfvrypmj/ni7AxXnYFYxcni6e7Eo2qAL6XNXCNdQgjTipPkW37uJCZCDrqqp4fUj1M+H+nZSlGM+b0mReqDZVQzfFNMpji/oFLQY2UUKRTHDEoInFwBM9aAx5LxCuXty2p6cWDiB7s16ctgq4GWHlHQRzz4wd6rN8Kp7lgxu4z35eUjPx4f3ILlGXUbqyhpY6/ZMT8PJ3GdyaGSnVrPq05zA9/liN+bNczkwCtXMcSa3GImOal7lSJgX7/UPxai3/IT6r772qqIVsgvIHIyuWIt0OanmFax6Jz4rgIxQexQXoZwLJTBmiPCRpWgjrb9SzkgPI1kLP/cxaljvxcYJab+Vpc8Cw9uCrcVZTerF1rZcGqJfIVTpkJX0SBRsH7GTJPehopEcf8wIwEmcuGk/lm1yyw==', # lint:ignore:140chars
  }

  users::create { 'deploy':
    system              => true,
    password            => $password,
    ssh_authorized_keys => unique($ssh_authorized_keys_all),
    ssh_priv_keys       => unique($ssh_priv_keys_all),
    ssh_config_opts     => $ssh_config_opts,
  }

  file{ '/home/deploy/cronscripts':
    ensure  => directory,
    owner   => 'deploy',
    group   => 'deploy',
    mode    => '0755',
    require => Users::Create['deploy'],
  }

  sudo::conf { 'ttv-deploy_user':
    priority => 99,
    source   => "puppet:///modules/${module_name}/users/sudoers.deploy",
  }
}
