class twitch::users::git (
  $password            = undef,
  $home                = '/var/lib/git',
  $ssh_authorized_keys = [
  ],
  $ssh_priv_keys       = [
  ],
  $ssh_config_opts     = {}
) inherits twitch::params {
  validate_array($ssh_authorized_keys, $ssh_priv_keys)
  validate_hash($ssh_config_opts)

  users::create { 'git':
    home                => $home,
    ssh_authorized_keys => $ssh_authorized_keys,
    ssh_priv_keys       => $ssh_priv_keys,
    ssh_config_opts     => $ssh_config_opts,
    system              => true
  }
}
