class twitch::users::puppet (
  $password            = undef,
  $home                = '/var/lib/puppet',
  $ssh_authorized_keys = [
  ],
  $ssh_priv_keys       = [
    'puppetmaster_github_deploy_key',
  ],
  $ssh_config_opts     = {
    'Host git.internal.justin.tv' => {
      'IdentityFile' => '~/.ssh/puppetmaster_github_deploy_key'
    }
  }
) inherits twitch::params {
  validate_array($ssh_authorized_keys, $ssh_priv_keys)
  validate_hash($ssh_config_opts)

  users::create { 'puppet':
    home                => $home,
    ssh_authorized_keys => $ssh_authorized_keys,
    ssh_priv_keys       => $ssh_priv_keys,
    ssh_config_opts     => $ssh_config_opts,
    system              => true
  }
}
