class twitch::users::root (
  $password            = undef,
  $home                = '/root',
  $ssh_authorized_keys = [
  ],
  $ssh_priv_keys       = [
  ],
  $ssh_config_opts     = $twitch::params::root_ssh_config,
) inherits twitch::params {
  validate_array($ssh_authorized_keys, $ssh_priv_keys)
  validate_hash($ssh_config_opts)

  users::create { 'root':
    password            => $password,
    ssh_authorized_keys => $ssh_authorized_keys,
    ssh_priv_keys       => $ssh_priv_keys,
    ssh_config_opts     => $ssh_config_opts,
    home                => $home,
  }

  file{ '/root/.ssh/authorized_keys':
    ensure  => 'absent',
    owner   => 'root',
    group   => 'root',
    mode    => '0600',
    require => Users::Create['root'],
  }
}
