# Installs and manages config of amazon-ssm-agent
class twitch_amazon_ssm_agent (
  $ensure                       = $::ec2_instance_id ? { undef => 'present', default => 'absent' },
  $ssm_agent_pkg_version        = 'present',
  $ssm_agent_common_pkg_version = 'present',
) {

  if $ensure == 'present' {
    include ::twitch_amazon_ssm_agent::check
    anchor { '::twitch_amazon_ssm_agent::begin': }
    -> class { '::twitch_amazon_ssm_agent::install': }
    ~> class { '::twitch_amazon_ssm_agent::service': }
    -> anchor { '::twitch_amazon_ssm_agent::end': }
  } else {
    anchor { '::twitch_amazon_ssm_agent::begin': }
    -> class { '::twitch_amazon_ssm_agent::service': }
    -> class { '::twitch_amazon_ssm_agent::install': }
    -> anchor { '::twitch_amazon_ssm_agent::end': }
  }
}
