# Installs amazon-ssm-agent
#
class twitch_amazon_ssm_agent::install {
  include twitch_amazon_ssm_agent
  $ssm_agent_pkg_ensure = $twitch_amazon_ssm_agent::ensure ? {
    'present' => $twitch_amazon_ssm_agent::ssm_agent_pkg_version,
    default   => absent,
  }
  $ssm_agent_common_pkg_ensure = $twitch_amazon_ssm_agent::ensure ? {
    'present' => $twitch_amazon_ssm_agent::ssm_agent_common_pkg_version,
    default   => absent,
  }
  package { 'amazon-ssm-agent':
    ensure => $ssm_agent_pkg_ensure,
  }
  package { 'twitch-vidops-amazon-ssm-agent-common':
    ensure  => $ssm_agent_common_pkg_ensure,
    require => Package['amazon-ssm-agent'],
  }
}
