import iptc
import diamond.collector

tables_list = [iptc.Table.FILTER, iptc.Table.RAW]


class IPtablesCollector(diamond.collector.Collector):
    def collect(self):
        for table_name in tables_list:
            table = iptc.Table(table_name)
            for chain in table.chains:
                for rule in chain.rules:
                    for match in rule.matches:
                        (packets, bytes) = rule.get_counters()
                        pkt_name = "iptables.{0}.{1}.{2}.{3}.packets".format(table.name, chain.name.lower(), rule.target.name.lower(), match.name)  # noqa: E501
                        self.log.debug("%s %s" % (pkt_name, packets))
                        self.publish(pkt_name, packets)

                        byt_name = "iptables.{0}.{1}.{2}.{3}.bytes".format(table.name, chain.name.lower(), rule.target.name.lower(), match.name)  # noqa: E501
                        self.log.debug("%s %s" % (byt_name, bytes))
                        self.publish(byt_name, bytes)
        table.refresh()
