# to apply ddos settings to a box
class twitch_antiddos (
  $purge_unmanaged_rules = true,
  $drop_synproxy         = false,
) {
  validate_bool(str2bool($drop_synproxy))
  validate_bool(str2bool($purge_unmanaged_rules))

  if versioncmp($::lsbmajdistrelease, '16.04') >= 0 {

    require ::twitch_netfilter
    require ::firewall
    include ::twitch_antiddos::monitoring

    # TODO: Explicitly manage addition/removal of firewall rules
    #   Not purging would also mean that rules that are not declared will not
    #   be automatically cleaned
    resources { 'firewall':
      purge => str2bool($purge_unmanaged_rules),
    }

    # SEC-3940
    # https://w.amazon.com/bin/view/AWS_IT_Security/FAQs/AWS-2019-005/
    # TODO mss drop was added as a workaround for vulnerability in a linux kernel
    # TODO this should be removed as soon as we will install patched kernels

    # Note:
    #   Removing or adding this rule is not a disruptive change
    if versioncmp($kernelrelease, '4.15.0-54-generic') >= 0 {
      $raw_ensure = 'absent'
    } else {
      $raw_ensure = 'present'
    }

    firewall { '020 drop small mss':
      ensure    => 'absent',
      chain     => 'INPUT',
      proto     => 'tcp',
      tcp_flags => 'FIN,SYN,RST,ACK SYN',
      mss       => '0:168',
      action    => 'drop',
      require   => Resources['firewall'],
    }

    firewall { '020 raw drop small mss':
      ensure    => $raw_ensure,
      table     => 'raw',
      chain     => 'PREROUTING',
      proto     => 'tcp',
      tcp_flags => 'FIN,SYN,RST,ACK SYN',
      mss       => '0:168',
      action    => 'drop',
      require   => Resources['firewall'],
    }

    ###########################################################################
    # WARNING
    # -------
    #
    # Disabling or enabling $drop_synproxy is a DISRUPTIVE change. This will
    # break existing tcp connections on ports 80, 443, and 1935 due to
    # conntrack.
    #
    # If necessary, hostclasses that applies this change MUST be drained first
    # to avoid service disruption.
    ###########################################################################
    if str2bool($drop_synproxy) {
      sysctl::value { 'net.ipv4.tcp_congestion_control': value =>  'htcp'}

      include ::twitch_antiddos::sysctl

      firewall { '010 PORTS notrack FIN,SYN,RST,ACK SYN':
        table     => 'raw',
        chain     => 'PREROUTING',
        iniface   => "${::default_gateway_interface}", #lint:ignore:only_variable_string
        proto     => 'tcp',
        dport     => ['80','443','1935'],
        tcp_flags => 'FIN,SYN,RST,ACK SYN',
        jump      => 'NOTRACK',
        require   => Resources['firewall'],
        before    => Firewall['020 drop small mss', '020 raw drop small mss'],
      }

      firewall { '050 ACL_OPENED_PORTS SYNPROXY':
        chain            => 'INPUT',
        iniface          => "${::default_gateway_interface}", #lint:ignore:only_variable_string
        proto            => 'tcp',
        dport            => ['80','443','1935'],
        ctstate          => [
          'INVALID',
          'UNTRACKED',
        ],
        jump             => 'SYNPROXY',
        synproxy_protect => true,
        require          => [
          Firewall['020 drop small mss'],
          Firewall['020 raw drop small mss'],
          Firewall['010 PORTS notrack FIN,SYN,RST,ACK SYN'],
        ],
      }

      firewall { '090 ACL_OPENED_PORTS SYNPROXY Drop catchall':
        chain   => 'INPUT',
        iniface => "${::default_gateway_interface}", #lint:ignore:only_variable_string
        proto   => 'tcp',
        dport   => ['80','443','1935'],
        state   => 'INVALID',
        action  => 'drop',
        require => Firewall['050 ACL_OPENED_PORTS SYNPROXY'],
      }

    }
  } else {
    notify { "Current distro release (${::lsbmajdistrelease}) is not supported, ensure a newer distro version is used": }
  }

}
