# Monitor iptables and conntrack metrics via Diamond
class twitch_antiddos::monitoring (
  $enable = false,
) {
  validate_bool(str2bool($enable))

  $provider = 'twitch_pip'

  if str2bool($enable) {
    $_python_iptables_ensure = $::lsbdistcodename ? {
      'xenial' => '0.11.0',
      default  => '0.13.0',
    }

    package { 'python-iptables':
      ensure   => $_python_iptables_ensure,
      provider => $provider,
    }

    twitch_diamond::collector { 'IPtablesCollector':
      enable  => true,
      content => file("${module_name}/IPtablesCollector.py"),
      require => Package['python-iptables'],
    }

    twitch_diamond::collector { 'ConnTrackCollector':
      enable  => true,
      require => Package['python-iptables'],
    }
  }
  else {
    package { 'python-iptables':
      ensure   => 'absent',
      provider => $provider,
    }
  }
}
