class twitch_anycast::health_enforcer (
) {

  include twitch_nsca::nsca_client
  include twitch_python
  include twitch_python::pip::install

  $script_name    = 'anycast_health_enforcer.py'
  $twitch_basedir = hiera('twitch_basedir','/opt/twitch')
  $app_dir        = "${twitch_basedir}/anycast_health_enforcer"

  file { $app_dir:
    ensure => 'directory',
  }

  file { "${app_dir}/${script_name}":
    source  => "puppet:///modules/${module_name}/${script_name}",
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    require => Class['twitch_nsca::nsca_client'],
  }

  file { "/usr/local/bin/enforcer_maintenance.sh":
    source  => "puppet:///modules/${module_name}/enforcer_maintenance.sh",
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
  }

  $virtenv_dir = "${app_dir}/virtualenv"
  python::virtualenv { $virtenv_dir:
    path    => [ '/usr/bin', '/usr/local/bin', '/bin' ],
    require => Class['twitch_python'],
  }

  # TODO: this is generally a terrible way of redefining the 'requests' package
  python::pip { 'anycast_health_enforcer':
    pkgname    => 'requests',
    virtualenv => $virtenv_dir,
  }

}
