# Twitch Anycast Health Enforcer

Installs the Go Anycast Health Enforcer.

Provides two defines:
  - `service` to create services with interfaces
  - `servicecheck` to create checks for those services.

Can be used in manifests or in hiera.

More documentation here: https://git-aws.internal.justin.tv/vidops/anycast-health-enforcer

## Hiera Example

```yaml
classes:
  - twitch_anycast_health_enforcer
twitch_anycast_health_enforcer::services:
  'test_server':
    healthy: 'any'
    interval: '10s'
    addresses:
      - "10.1.1.123"
      - "10.1.1.127"
  'test_service':
    healthy: ''
    interval: '10s'
    addresses:
      - "10.1.1.113"
      - "10.1.1.117"
twitch_anycast_health_enforcer::servicechecks:
  '/bin/true':
    service: 'test_server'
    type: 'cmd'
  '127.0.0.1:22':
    type: 'tcp'
    service: 'test_server'
  'http://localhost:8500':
    type: 'http'
    service: 'test_server'
    return_code: [200, 301, 302]
  'http://localhost:80':
    type: 'http'
    service: 'test_service'
    return_code: [200, 301, 302]
```

## Manifest Example

```puppet
# Create an enforcer entry for the service that consumes these interfaces.
twitch_anycast_health_enforcer::service { 'usher_proxy':
  addresses => [
    "192.108.239.254",
    "23.160.0.254",
  ],
  community => 12345,
}
# You can have any number of service checks.
twitch_anycast_health_enforcer::servicecheck { 'http://127.0.0.1:80/alive':
  service => 'usher_proxy',
  type    => 'http',
}
```
