# Twitch Anycast Health Enforcer config
#
class twitch_anycast_health_enforcer::config inherits twitch_anycast_health_enforcer {
  validate_absolute_path($twitch_anycast_health_enforcer::config_file)
  validate_absolute_path($twitch_anycast_health_enforcer::service_dir)
  validate_integer($twitch_anycast_health_enforcer::envoy_port,65535,1)

  file { $twitch_anycast_health_enforcer::config_file:
    ensure  => $twitch_anycast_health_enforcer::ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch_anycast_health_enforcer/anycast-config.erb'),
  }

  file { $twitch_anycast_health_enforcer::service_dir:
    ensure  => 'directory',
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    purge   => true,
    force   => true,
    recurse => true,
  }
}
