# Twitch Anycast Health Enforcer
#
class twitch_anycast_health_enforcer (
  $ensure      = 'present',
  $config_file = $twitch_anycast_health_enforcer::params::config_file,
  $service_dir = $twitch_anycast_health_enforcer::params::service_dir,
  $envoy_port  = $twitch_anycast_health_enforcer::params::envoy_port,
  $package     = $twitch_anycast_health_enforcer::params::package,
  $version     = $twitch_anycast_health_enforcer::params::version,
) inherits twitch_anycast_health_enforcer::params {
  $services      = hiera_hash('twitch_anycast_health_enforcer::services', {})
  $servicechecks = hiera_hash('twitch_anycast_health_enforcer::servicechecks', {})

  if $ensure == 'present' {
    anchor { '::twitch_anycast_health_enforcer::begin': }
    -> class { '::twitch_anycast_health_enforcer::install': }
    -> class { '::twitch_anycast_health_enforcer::config': }
    ~> class { '::twitch_anycast_health_enforcer::ahe_service': }
    -> anchor { '::twitch_anycast_health_enforcer::end': }

    # Allow resrouce creation using hiera, against all better judgement. ;)
    if !empty($services) {
      ensure_resources('twitch_anycast_health_enforcer::service', $services)
    }
    if !empty($servicechecks) {
      ensure_resources('twitch_anycast_health_enforcer::servicecheck', $servicechecks)
    }

  # Remove.
  } else {
    anchor { '::twitch_anycast_health_enforcer::begin': }
    -> class { '::twitch_anycast_health_enforcer::ahe_service': }
    -> class { '::twitch_anycast_health_enforcer::config': }
    -> class { '::twitch_anycast_health_enforcer::install': }
    -> anchor { '::twitch_anycast_health_enforcer::end': }
  }
}
