# Create checks for a service.
#
define twitch_anycast_health_enforcer::servicecheck (
  $service,
  $type,
  $ensure      = 'present',
  $check       = $name,
  $timeout     = '5s',
  $return_code = [],
  $source      = ''
) {
  include twitch_anycast_health_enforcer

  validate_re(downcase($type),'^(cmd|http|tcp)$')
  validate_string($timeout,$source)
  validate_array($return_code)
  if !defined(Twitch_anycast_health_enforcer::Service[$service]) {
    fail("Anycast service ${service} does not exist in catalog.")
  }

  if $ensure == 'present' {
    concat::fragment { "anycast-servicecheck-${name}":
      target  => "anycast-service-${service}",
      order   => '20',
      content => template('twitch_anycast_health_enforcer/anycast-servicecheck.erb'),
    }
  }
}
