# twitch_apt
class twitch_apt (
  $twitch_repo_testing = false,
) inherits twitch_apt::params {

  include apt
  include twitch_apt::mirror

  if str2bool($::systemd) {
    file { '/usr/local/sbin/apt-puppet-wrapper.sh':
      ensure => 'file',
      owner  => 'root',
      group  => 'root',
      mode   => '0755',
      source => "puppet:///modules/${module_name}/usr/local/sbin/apt-puppet-wrapper.sh",
    }

    twitch_systemd::drop_in { 'override.conf':
      unit   => 'apt-daily.service',
      path   => '/etc/systemd/system',
      source => "puppet:///modules/${module_name}/etc/systemd/system/apt-daily.service.d/override.conf",
    }
  }
}
