# apt mirror maker
class twitch_apt::mirror (
  $ubuntu             = $twitch_apt::mirrors['ubuntu'],
  $twitch             = $twitch_apt::mirrors['twitch'],
  $twitch_apt_gpg_key = $twitch_apt::mirrors['twitch_apt_gpg_key'],
  $twitch_mirror_key  = $twitch_apt::twitch_mirror_key,
  $install_recommends = $twitch_apt::install_recommends,
) inherits twitch_apt {

  # these are default for ubuntu
  $ubuntu_releases = {
    "ubuntu-${::lsbdistcodename}"           => { release => $::lsbdistcodename },
    "ubuntu-${::lsbdistcodename}-updates"   => { release => "${::lsbdistcodename}-updates" },
    "ubuntu-${::lsbdistcodename}-backports" => { release => "${::lsbdistcodename}-backports" },
    "ubuntu-${::lsbdistcodename}-security"  => { release => "${::lsbdistcodename}-security" }
  }

  # here we use our internal mirror and official repos
  $sources_defaults = {
    location => $ubuntu,
    repos    => 'main restricted universe multiverse',
    architecture => 'amd64',
  }

  create_resources(apt::source, $ubuntu_releases, $sources_defaults)

  # pin official repos to priority 500
  create_resources(apt::pin, $ubuntu_releases, {priority => 500})

  # optionally include additional components from twitch repo
  $repos = $twitch_apt::twitch_repo_testing ? {
    true  => 'main testing',
    false => 'main',
    default => "main ${twitch_apt::twitch_repo_testing}",
  }

  # custom 'twitch' ops repo
  apt::source { 'twitch':
    location     => $twitch,
    repos        => $repos,
    include      => { 'src' => false },
    architecture => 'amd64',
    key          => {
      'id'     => $twitch_mirror_key,
      'source' => $twitch_apt_gpg_key,
    },
  }

  # Ubuntu Extended Security Maintenance for Xenial 16.04
  if $::lsbdistcodename in ['xenial'] {
    apt::source { 'xenial-infra-security':
      location     => 'http://package-repo.live-video.a2z.com/ubuntu-esm',
      repos        => 'main',
      architecture => 'amd64',
      release      => 'xenial-infra-security',
    }

    apt::source { 'xenial-infra-updates':
      location     => 'http://package-repo.live-video.a2z.com/ubuntu-esm',
      repos        => 'main',
      architecture => 'amd64',
      release      => 'xenial-infra-updates',
    }
  }


  # overwrite /etc/apt/apt.conf
  file { '/etc/apt/apt.conf':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => "# Managed by puppet. Leave empty. Use apt::settings.\n",
    before  => Exec['apt_update'],
  }

  apt::setting { 'conf-norecommend':
    ensure   => $install_recommends,
    content  => 'APT::Install-Recommends "0";',
    priority => '99',
  }

  Class['apt::update'] -> Package <| tag != 'virtual' and ensure != 'absent' |>

  class { 'locales':
    default_locale => 'en_US.UTF-8',
    locales        => ['en_US.UTF-8 UTF-8'],
  }
}
