# barrel is a daemon which forwards data to trace
class twitch_barrel (
  $enable             = $twitch_barrel::params::enable,
  $consul_environment = $twitch_barrel::params::consul_environment,
  $deploy_environment = $twitch_barrel::params::deploy_environment,
  $repository         = $twitch_barrel::params::repository,
  $memory_limit_bytes = $twitch_barrel::params::memory_limit_bytes,
  $consul_host        = $twitch_barrel::params::consul_host,
) inherits twitch_barrel::params {
  if $::lsbmajdistrelease < '12' or $facts['osfamily'] != 'Debian' {
    notify { 'Not installing barrel - only supports Ubuntu >= 12.04': }
  } else {

    validate_string($consul_environment, $deploy_environment)
    validate_re($repository, '[A-Za-z0-9_]/[A-Za-z0-9_]')

    if $enable {
      # require the courier module
      require courier

      # register the service in consul
      consul::service { 'villagers':
        consul_tags => [$consul_environment],
      }

      # install the package via courier
      # villagers is a set of binaries deployed to all systems
      # https://git.internal.justin.tv/release/villagers
      courier::install { 'villagers':
        consul_host => $consul_host,
        env         => $deploy_environment,
        repo        => $repository,
        basedir     => $twitch_barrel::params::base_directory,
        require     => Consul::Service['villagers'],
      }

      # manage the service via daemontools
      daemontools::supervise { 'barrel':
        wd             => "${twitch_barrel::params::base_directory}/villagers/current/bin",
        daemon         => "${twitch_barrel::params::base_directory}/villagers/current/bin/barrel",
        options        => '2>&1',
        down           => false,
        user           => 'nobody',
        daemon_dir     => '/var/lib/service',
        enable_cgroups => true,
        cgroups_rules  => $twitch_barrel::params::cgroups_rules,
        syslog         => 'local3',
        require        => Courier::Install['villagers'],
      }
    } else {
      # Ensure barrel isn't running if it was previously installed
      exec { '/usr/local/bin/remove_service barrel':
        onlyif => 'test -L /etc/service/barrel',
      }
    }
  }
}
