# twitch_base

#### Table of Contents
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Overview

- [Overview](#overview)
- [Module Description](#module-description)
- [Setup](#setup)
  - [What twitch_base affects](#what-twitch_base-affects)
  - [Beginning with twitch_base](#beginning-with-twitch_base)
- [Usage](#usage)
  - [Class twitch_base parameters](#class-twitch_base-parameters)
- [Reference](#reference)
  - [Classes](#classes)
  - [Defines](#defines)
- [Limitations](#limitations)
- [Contribution](#contribution)
  - [Making Changes](#making-changes)
  - [Pull Requests](#pull-requests)
  - [Code Reviews](#code-reviews)
- [Release Notes/Contributors/Etc **Optional**](#release-notescontributorsetc-optional)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
## Overview

twitch_base installs only the minimal requirements to create a minimal bootable os for netboot or bare metal.

## Module Description

twitch_base installs only the minimal requirements to create a minimal bootable os for netboot or bare metal. This is limited to modules that manage networking, ldap authentication, kernel versioning and system + inventory management.

Modules are installed in two different phases
1. netboot image / disk image
   * modules required to boot
     * kernel
     * system management
       * apt
       * systemd
       * ipmi
     * networking
       * teamd
       * logging
       * ntp
       * lldp
1. post boot
   * inventory agent
   * authorization
     * ssm
     * milliner
   * core
     * only for bare metal that have not been netbooted

## Setup

### What twitch_base affects

* preseed
* netboot
  * image generation
  * netbooted hosts
* all systems that run puppet

### Beginning with twitch_base

## Usage

Only expected use is to be the only class included in hiera's default.yaml as:
```
   classes:
   - twitch_base
```

### Class twitch_base parameters
* twitch_base::cloudwatch
  * statsd_port
  * statsd_ensure
* twitch_base::jtv_user
  * password
  * ssh_authorized_keys
  * ssh_config_opts

## Reference

### Classes

* twitch_base
* twitch_base::cloudwatch
* twitch_base::files
* twitch_base::jtv_user
* twitch_base::kernel
* twitch_base::params

### Defines
* none

## Limitations

## Contribution

### Making Changes

Contributions to this repository:

* need to be limited to what is described in [Module Description](#module-description).
  * Not doing so has created massive tech debt in the past, which lead to another massive cleanup still in progress (deprecation of the core module).
* should be reviewed via [Pull Requests](#pull-requests) before merging.
* must follow the [Code Contribution Guidelines].
* See the [Code Contribution Checklist] for a quick reference.
* Any changes outside of the scope should follow puppet best pratices and be included either by role or service module. e.g.

Add to classes in either environment or cluster in video-puppet/hiera_data
```
# environment/canary/video-tier1.yaml
---
classes:
  - twitch_random_service_modules
  - additional_module_1
  - additional_module_2
```
or

Add include in the service class
    edit video-tier1/manifests/init.pp or appropriate sub class in the module and include:
```
include additional_module_1
include additional_module_2
```

### Pull Requests
All pull requests must:
  - Have a description explaining the problem
  - Snippet of any output error
  - Snippet of any output showing the fixed results
  - Contain a link to a JIRA ticket
  - Have been linted:
   - `puppet-lint`
   - `flake8`
   - `puppet validate`
   - etc
  - Not contain lint errors. Run all new code through `puppet-lint`.

### Code Reviews

PR reviews require video core services approval before merging. If you need help finding a reviewer, ping the [#video-coreservices] Slack channel.

Contributions need to be limited to what is described in Module Description. Not doing so has created massive tech debt in the past, which lead to another massive cleanup still in progress (deprecation of the core module). Any changes outside of the scope should follow puppet best pratices and be included either by role or service module. e.g.

Add to classes in either environment or cluster in video-puppet/hiera_data
```
# environment/canary/video-tier1.yaml
---
classes:
  - twitch_random_service_modules
  - additional_module_1
  - additional_module_2
```
or

Add include in the service class
    edit video-tier1/manifests/init.pp or appropriate sub class in the module and include:
```
include additional_module_1
include additional_module_2
```

## Release Notes/Contributors/Etc **Optional**

[#video-coreservices]: https://twitch.slack.com/messages/CEVFAMMLH/
[Code Contribution Guidelines]: https://wiki.xarth.tv/display/VID/Puppet+Usage+Guidance+-+Video+Platform
[Code Contribution Checklist]: https://wiki.xarth.tv/display/VID/Puppet+Usage+Guidance+-+Video+Platform#PuppetUsageGuidanceVideoPlatform-GeneralGuidance
