# Returns the contents of /proc/cmdline as a hash
Facter.add('cmdline') do
  cmdline = '/proc/cmdline'

  confine { Gem::Version.new(Facter.version) >= Gem::Version.new('2') }
  confine { File.exist?(cmdline) }

  setcode do
    retval = {}
    begin
      File.read(cmdline).chomp.split.each do |x|
        # we want a maximum of 2 fields (eg. BOOT_IMAGE=LABEL=/foo)
        i, j = x.split('=', 2)

        # setting value to Nil isn't very helpful
        j = true if j.nil?

        # first kernel arg wins. skip it. log if debugging
        if retval.has_key?(i)
          Facter.debug("Duplicate cmdline['#{i}']. skipping")
          next
        else
          Facter.debug("Setting value for cmdline['#{i}']")
          retval[i] = j
        end
      end
    rescue => details
      Facter.warn("Could not gather data from /proc/cmdline: #{details.message}")
    end
    retval
  end
end
