# ipaddres_primary.rb
#
# Ported from a recent update to Facter:
#   https://github.com/puppetlabs/facter/pull/1258

require 'facter/util/ip'
require 'facter/util/file_read'

def get_linux_default_interface
  iface = nil
  Facter::Util::FileRead.read("/proc/net/route").split("\n").each do |line|
    parts = line.split()
    if parts[1] == "00000000"
      iface = Facter::Util::IP.alphafy(parts[0])
      break
    end
  end
  iface
end

Facter.add(:ipaddress_primary) do
  confine :kernel => :linux
  setcode do
    iface = get_linux_default_interface
    Facter.value("ipaddress_#{iface}".to_sym)
  end
end

Facter.add(:netmask_primary) do
  confine :kernel => :linux
  setcode do
    iface = get_linux_default_interface
    Facter.value("netmask_#{iface}".to_sym)
  end
end
