require 'facter/operatingsystem/implementation'

lsb_release = {}

File.readlines('/etc/lsb-release').each do |line|
  key, value = line.split '='
  lsb_release[key] = value.strip
end

Facter.add(:os, :type => :aggregate) do
  has_weight 100

  def os
    @os ||= Facter::Operatingsystem.implementation
  end

  chunk(:name) do
    os_hash = {}
    os_hash['name'] = lsb_release['DISTRIB_ID']
    os_hash
  end

  chunk(:family) do
    os_hash = {}
    if (osfamily = os.get_osfamily)
      os_hash['family'] = osfamily
      os_hash
    end
  end

  chunk(:release) do
    os_hash = { 'release' => {} }
    os_hash['release']['major'] = lsb_release['DISTRIB_RELEASE']
    os_hash['release']['full'] = lsb_release['DISTRIB_RELEASE']
    os_hash
  end

  chunk(:lsb) do
    os_hash = { 'lsb' => {} }
    distdescription = lsb_release['DISTRIB_DESCRIPTION'].gsub!(/\A"|"\Z/, '')
    os_hash['lsb']['distcodename'] = lsb_release['DISTRIB_CODENAME']
    os_hash['lsb']['distid'] = lsb_release['DISTRIB_ID']
    os_hash['lsb']['distdescription'] = distdescription
    os_hash['lsb']['distrelease'] = lsb_release['DISTRIB_RELEASE']
    os_hash['lsb']['majdistrelease'] = lsb_release['DISTRIB_RELEASE']
    os_hash
  end
end
