# Class: twitch_base::cloudwatch
#
# Setup default cloudwatch configs that should go to all running machines
class twitch_base::cloudwatch (
  $statsd_port   = 8125,
  $statsd_ensure = 'present',
) {
  include video_cloudwatch::csm

  video_cloudwatch::logfile { 'consul': }
  video_cloudwatch::logfile { 'consul-template': }
  video_cloudwatch::logfile { 'puppet-cron': }
  video_cloudwatch::logfile { 'sandstorm-agent': }

  video_cloudwatch::logfile { 'kernel':
    file_path        => '/var/log/kern.log',
    timestamp_format => '%Y-%m-%dT%H:%M:%S-07:00',
  }

  video_cloudwatch::logfile { 'auth':
    file_path        => '/var/log/auth.log',
    timestamp_format => '%Y-%m-%dT%H:%M:%S-07:00',
  }

  video_cloudwatch::logfile { 'bash_history':
    timestamp_format => '%Y-%m-%dT%H:%M:%S',
  }

  video_cloudwatch::statsd {'statsd_listener':
    ensure => $statsd_ensure,
    port   => $statsd_port,
  }
}
