# twitch_base
class twitch_base (
) inherits twitch_base::params {
  include twitch_base::jtv_user
  include twitch_base::files
  include twitch_base::kernel
  include systemd::resolved

  include twitch_apt
  include twitch_freeipmi_tools
  include ethtool

  # Purge any inventory agent from aws or during netboot build process
  # bare metal or netboot (post boot) gets it installed
  if defined('$::ec2_instance_id') or $::packer_build_name {
    class { 'twitch_inventory_agent':
      ensure => absent,
    }
    package { 'twitch-mgdbagent':
      ensure => absent,
    }
  } else {
    include twitch_inventory_agent
  }

  include twitch_kernel

  # these things are excluded from vagrant
  # but included everywhere else
  if ($::vagrant == undef) {
    include twitch_useraccess
    include twitch_proxy_config
    if ($::ec2_metadata == undef) {
      include twitch_teamd
    }
  }

  if $::virtual == 'physical' or $::cmdline['boot'] == 'live' or $::packer_build_name {
    include twitch_lldp
  }

  include twitch_lshw
  include twitch_ntp
  include twitch_puppet
  include twitch_ssh
  include twitch_syslog
  include twitch_systemd
  include users
  include interfaces
  include twitch_utils
  include twitch_vars
  include twitch_dirs

  # netboots only
  if $::cmdline['boot'] == 'live' or $::packer_build_name {
    include twitch_pip
    include twitch_ipmitool
    include twitch_netboot
  } else {
    include core

    # Exclude from running netbooted images for the moment
    include twitch_antiddos
  }

  # Exclude from vagrant
  # Exclude from netboot image building
  if $::packer_build_name == undef and $::vagrant == undef {
    # classic classes brought over from vidcs and video hiera
    include twitch_vidops_tools
    include twitch_amazon_ssm_agent
    include vtp_ssm_sidecar # requires SSM
    include milliner        # requires SSM
    include video_codedeploy
    include twitch_base::cloudwatch
  }
}
