# twitch_base::jtv_user
class twitch_base::jtv_user (
  $password            = $twitch_base::params::jtv_password_hash,
  $ssh_authorized_keys = $twitch_base::params::jtv_ssh_authorized_keys,
  $ssh_config_opts     = $twitch_base::params::jtv_ssh_config,
) inherits twitch_base::params {

  validate_string($password)
  validate_array($ssh_authorized_keys)
  validate_hash($ssh_config_opts)

  users::create { 'jtv':
    password            => $password,
    ssh_authorized_keys => $ssh_authorized_keys,
    ssh_config_opts     => $ssh_config_opts,
  }

  file{ '/home/jtv/cronscripts':
    ensure  => directory,
    owner   => 'jtv',
    group   => 'jtv',
    mode    => '0755',
    require => Users::Create['jtv']
  }

  @ssh_authorized_key { 'jtv_public_clean-0415':
    ensure => 'present',
    type   => 'ssh-rsa',
    key    => 'AAAAB3NzaC1yc2EAAAADAQABAAACAQCyi9cp2+n0d3gfwpfARCIsie0CIpOM2L9UyZwpcdaNOwJ/cHwca1svxg0AMjMK5cG88W37n7MeM7LJ1M+i8TO8WqNymg1pGJMMGTJgLlUHH7HB6Fvxh3yqLvq4J1tA8MX1eM4cKq3HfOWgCU9Kw3E0Wcr4Ss9C38SgMNXLq0L66HZRd4yF737sSTpVuC70iT9cGOoRjfzEFmFy+HbUaJ2VveTBBBSv0f5wdHF3JbGkmgUmNCMVf4hZLIUPxv6jLWDUPpl7fqQwxjy5rg+l9pGqpHAN46RIVr6XwX/YhMWN7bWCDNMB+dupSFLvHncwO9DwFzifk7aVWtTOit21O0yYWzCWfipUxJP6ybc1Hv6Z7uljgIo4AU7/VCY/T48cIwvRPbuGXVqo2yWi3mU/gpXhCvIAE2oTFljetFvMnbIm8OWg7UIid8CGTkZMrsTrwMjBn+HdeLYDhMqegmNcEtCvUOHJhMd2n/hzluX4jaczZdpPk4lMmlPHgCBNtphlgIlvlVeVvGD4jwrtrDD79cbifc4RW8cfOz45DhyT2HhqsbO+X6HAjejOuDItGA9ve4C7R9CZ0JXqcMtw4EKRNbhfVLeIY9spb1WOrSxzsotTxabDbB7LNyZJ2aVTnQCVjb4QUo2lySVXXuRpnuEbqapVn0DvSfQB2hdewib8sULOow==',
  }

}
