# Anycast configuration for twitch_cdncache module
class twitch_cdncache::anycast inherits twitch_cdncache {
  if !$::disable_anycast and $twitch_cdncache::loopback_addresses {
    include bird::monitoring
    include twitch_anycast_health_enforcer::monitoring
    validate_integer($community)
    twitch_anycast_health_enforcer::service { 'cdncache':
      interval   => '2s',
      window     => 4,
      threshold  => 2,
      healthy    => 'all',
      addresses  => $twitch_cdncache::loopback_addresses,
      community  => $twitch_cdncache::community,
      flap_limit => -1,
      checks     => {
        '/usr/lib/nagios/plugins/check_http -p 80 -H 127.0.0.1 -u /assignable -e 200' => { # Check Varnish is up/assignable
          type    => 'cmd',
          timeout => '4s',
        },
      },
    }
  }
}
