# This class sets up a video-cdncache server, which is a variant of video-edge that CDNs use as an origin
class twitch_cdncache (
  $loopback_addresses = $twitch_cdncache::params::loopback_addresses,
  $community          = $twitch_cdncache::params::community,
) inherits twitch_cdncache::params {
  include bird
  include twitch_nrdp
  include twitch_cdncache::anycast

  $consul_port = 80
  $consul_tags = [ 'role-cdncache' ]
  $consul_env = pick($::twitch_environment, $twitch_environment, 'production')

  consul::service { 'video-hls-replication':
    port        => $consul_port,
    consul_tags => concat(["fqdn=${::fqdn}"], $consul_tags, $consul_env),
  }

  class { 'darkseer': }

  # Using Bird process status to determine drain status
  # More information in https://wiki.twitch.com/display/VID/Draining+Hosts
  twitch_servicecheck::passive { 'server-status':
    command        => 'check_procs -C bird -w1:1 -c1:1',
    interval       => 1, # minutes between checks
    retry          => 2, # times to fail before reporting failure
    retry_interval => 1, # minutes between checks once reporting failure
  }

  # Add sandstorm checks to this sandstormified-host.
  realize(Twitch_nrdp::Check['check_sandstorm_agent'])
  realize(Twitch_nrdp::Check['check_sandstorm_agent_ops'])

  # cleanups - can be removed when we move to bionic

  class { 'twitch::haproxy::video_cdncache_ssl': }

  class { 'gatekeeper':
    ensure => absent,
  }

  class { 'varnish':
    version                => absent,
    varnish_enable         => false,
    varnishlog_enable      => false,
    varnishncsa_enable     => false,
    config_file            => 'default.vcl',
    varnishd_syslog_enable => false,
  }

  class { 'varnishshmparser':
    ensure => absent,
  }

  class { 'artm':
    ensure => absent,
  }
}
