# the goal of this manifest is to provide metadata to nagios for classification of nodes
# and how to check them

class twitch_clean_nagios::consul_service (
  $team, # d8a, systems, web, etc.
  $is_monitored, # true/false whether nagios should monitor this box
  $checks = [], # array of checks as strings
  $hostgroup,
  $contact_groups = undef,
) {

  $check_string = join($checks, ',')


  consul::service { "nagios":
    consul_tags    => ["team=${team}", # the goal of this is to filter nodes by whether or not they have this service, then by team
                        "is_monitored=${is_monitored}",   # this should be true/false
                        "hostgroup=${hostgroup}",
                        "checks=${check_string}", # csv of checks this host should have
                        "contact_groups=${contact_groups}", # who to alert when the box is critical
                      ],
    service_name   => "nagios",
  }
}

