# Send a logfile to cloudwatch.

define twitch_cloudwatchlogs::log (
  $path,
  $service         = undef,
  $awslogs_env     = pick($::twitch_environment, $twitch_environment, 'production'),
  $pop             = $::pop,
  $streamname      = $::fqdn,
  $datetime_format = '%b %d %H:%M:%S',
  $log_group_name  = undef,
) {
  include twitch_cloudwatchlogs

  if $log_group_name == undef and $service == undef {
    fail('must provide one of: service, log_group_name')
  }

  # validate_string passes OK for undef.
  validate_string($awslogs_env)
  validate_string($service)
  validate_string($path)
  validate_string($pop)
  validate_string($streamname)
  validate_string($datetime_format)
  validate_string($log_group_name)

  $log_group = $log_group_name ? {
    undef   => "/twitch/${pop}/${service}/${awslogs_env}",
    default => $log_group_name,
  }

  cloudwatchlogs::log { $name:
    path            => $path,
    streamname      => $streamname,
    datetime_format => $datetime_format,
    log_group_name  => $log_group,
  }
}
