# Parameters for cloudwatchlogs.
#
class twitch_cloudwatchlogs::params {
  $env                 = pick($twitch_environment, $::twitch_environment, 'production')
  $sandstorm_pfx       = "video/cloudwatch_logs/${env}"

  case $::operatingsystem {
    'CentOS': { $cloudwatch_access_key_path = '/etc/sysconfig/cloudwatchlogs' }
    default: { $cloudwatch_access_key_path = '/etc/default/cloudwatchlogs' }
  }
}
