# Cosmos is a stats daemon for baremetal hosts.
class twitch_cosmos (
  $ensure                    = $twitch_cosmos::params::ensure,
  $canary                    = $twitch_cosmos::params::canary,
  $cosmos_health             = $twitch_cosmos::params::cosmos_health,
  $node_type                 = $twitch_cosmos::params::node_type,
  $backend_port              = $twitch_cosmos::params::backend_port,
  $haproxy_sockets_path      = $twitch_cosmos::params::haproxy_sockets_path,
  $redis_addr                = $twitch_cosmos::params::redis_addr,
) inherits twitch_cosmos::params {

  if $canary {
    $consul_tags = [$::twitch_environment, 'canary', 'nodesAPI-reporter']
    $statsd_env = 'canary'
  } else {
    $consul_tags = [$::twitch_environment, 'nodesAPI-reporter']
    $statsd_env = $::twitch_environment
  }

  # The anchor pattern calls puppet classes in order, so this will install monitoring
  # before setting up the service. Additional classes can be added here as well
  anchor  { 'twitch_cosmos::begin': }
  -> class { 'twitch_cosmos::monitoring': }
  ~> class { 'twitch_cosmos::service': }
  -> anchor { 'twitch_cosmos::end': }
}
