# Cosmos is a stats daemon for baremetal hosts.
class twitch_cosmos::service () inherits twitch_cosmos {
  validate_bool($canary)

  $options = prefix(delete_undef_values({
    'env'              => $statsd_env,
    'addr'             => '0.0.0.0:8877',
    'node-name'        => $::pqdn,
    'node-type'        => $node_type,
    'ha-sockets-path'  => $haproxy_sockets_path,
    'statsd-addr'      => "statsd.central.twitch.a2z.com:8125",
    'statsd-prefix'    => 'video.cosmos',
    'statsd-rate'      => 1,
    'statsd-debug'     => false,
    'consul-prefix'    => 'node-max-config/cosmos/',
    'backend-port'     => $backend_port,
    'redis-addr'       => $redis_addr,
    'agent-addr'       => '0.0.0.0:8878',
  }), '-')

  $daemon_options = join(join_keys_to_values($options, '='), ' ')
  $systemd_exec_cmd = "/opt/twitch/cosmos/current/cosmos ${daemon_options} -systemd"

  # The below section is a generic implementation of twitch::service, but for
  # systemd instead of Daemontools. It also ensures that the systemd unit
  # is not started before Courier has installed Cosmos
  twitch_systemd::unit_file {'cosmos@.service':
    ensure  => $ensure,
    content => template('twitch_cosmos/cosmos.service.erb'),
  }

  consul::service { 'cosmos':
    ensure         => $ensure,
    port           => 8877,
    consul_tags    => $consul_tags,
    check_http     => "http://0.0.0.0:8877/health",
    check_interval => '5s'
  }

  courier::install { 'cosmos':
    ensure            => $ensure,
    repo              => 'video/cosmos',
    env               => $::twitch_environment,
    basedir           => '/opt/twitch',
    user              => 'jtv',
    group             => 'jtv',
    require           => Consul::Service['cosmos'],
    codedeploy_compat => true,
  }

  # Only use a redis password if we're running on weaver nodes.
  $rubick_ensure = $node_type ? {
    "weaver" => $ensure,
    default  => "absent",
  }

  twitch_sandstorm_agent::template { 'cosmos_config':
    destination     => '/etc/default/cosmos',
    ensure          => $rubick_ensure,
    owner           => 'root',
    group           => 'root',
    mode            => '0400',
    restart_command => '/opt/twitch/cosmos/current/courier/restart.sh',
    contents        => "REDIS_PASSWORD=\"{{ key \"video/rubick/${::twitch_environment}/redis_password\" }}\"",
    require         => Service['cosmos@blue'],
  }

  service { 'cosmos@blue':
    ensure    => running,
    enable    => true,
    subscribe => Twitch_systemd::Unit_file['cosmos@.service'],
    require   => Courier::Install['cosmos'],
  }
  # ends here
}
