class twitch_crashmonitor(
  $ensure        = 'present',
  $env           = pick($::twitch_environment, $twitch_environment, 'production'),
  $repo          = 'video/crashmonitor',
  $statsd_host   = hiera('statsd_host', 'statsd.internal.justin.tv'),
  $statsd_port   = hiera('statsd_port', '8125'),
  $stats_prefix  = 'video.crash',
  $s3_bucket     = 'twitch-video-coredumps',
  $use_sandstorm = true,
  $sandstorm_env = undef,
  $write_locally = 'no'
)
{
  if (versioncmp($::kernelmajversion, '2.6') <= 0) {
    fail("kernel major version $::kernelmajversion is not greater than 2.6")
  }

  # Enables environment prefixing discussed in ING-3450
  $deploy_environment_array = split($env, '-')
  $deploy_environment = $deploy_environment_array[0]

  # Due to how sandstorm works, a group cannot gain secrets to multiple environments
  # Putting the hack here instead of in provisioner multi-groups because crashmonitor
  # is one of the first, planned recipients of the milliner treatment, so this cruft
  # should be temporary
  if ( $sandstorm_env ) {
    $sandstorm_environment = $sandstorm_env
  } else {
    $sandstorm_environment = $deploy_environment ? {
      'canary' => 'production',
      default  => $deploy_environment,
    }
  }

  $crashmonitor_secret_ensure = $use_sandstorm ? {
    true    => $ensure,
    default => 'absent',
  }
  twitch_sandstorm_agent::template { 'crashmonitor_secret':
    ensure      => $crashmonitor_secret_ensure,
    destination => '/etc/crashmonitor.secret',
    mode        => '0400',
    contents    => template('twitch_crashmonitor/crashmonitor.secret.erb'),
    delete_dest => true,
  }

  $crashmonitor_args = join_keys_to_values(delete_undef_values({
    '-t'   => "%t",
    '-p'   => "%p"
  }), " ")


  $crashmonitor_cmd = join([
    "|/opt/twitch/crashmonitor/current/crashmonitor-wrapper.sh",
    $crashmonitor_args,
    "%e"
  ], " ")

  if $ensure == 'present' {
    require twitch_python::pip::statsd
    sysctl::value { "kernel.core_pattern": value => "$crashmonitor_cmd" }
  } else {
    sysctl::value { "kernel.core_pattern": value => 'core' }
  }

  file { '/etc/crashmonitor.cfg':
    ensure  => $ensure,
    content => template("${module_name}/crashmonitor.cfg.erb")
  }

  $tags = $deploy_environment ? {
    'canary' => ['canary', 'production'],
    default  => [$deploy_environment],
  }

  consul::service { "crashmonitor":
    ensure      => $ensure,
    consul_tags => $tags,
  }

  courier::install { "crashmonitor":
    ensure  => $ensure,
    env     => $deploy_environment,
    repo    => $repo,
    require => Consul::Service['crashmonitor']
  }

}
