define twitch_cron (
  $ensure      = undef,
  $command     = undef,
  $environment = undef,
  $hour        = undef,
  $minute      = undef,
  $month       = undef,
  $monthday    = undef,
  $user        = undef,
  $weekday     = undef,
) {
  $proxy_pre = 'PROXY_FILE=/etc/profile.d/proxy.sh; [ -f $PROXY_FILE ] && . $PROXY_FILE'

  $real_command = str2bool($::proxy_needed) ? {
    true    => "$proxy_pre; $command",
    default => $command,
  }

  $cron_name = regsubst($name, '[ \.:]', '_')
  cron::job { $cron_name:
    ensure      => $ensure,
    command     => $real_command,
    environment => $environment,
    hour        => $hour,
    minute      => $minute,
    month       => $month,
    date        => $monthday,
    user        => $user,
    weekday     => $weekday,
  }
  # After swithcing to cron::job, this was added to remove any cruft.
  # Added Jul'16, remove after every host (that uses this) runs puppet.
  # As of this writing, only twitch_geoip used this module...
  cron {$name: ensure => 'absent', user => $user}
}
