# This is just to get the lighthouse cert in a form that can be copied to the appliance.
class twitch_dcops::lighthouse {
  $key_prefix = 'dcops/lighthouse/production/lighthouse_sjc02_justin_tv'
  file { '/etc/lighthouse':
    ensure => 'directory',
    mode   => '0600',
    owner  => 'root',
    group  => 'root',
  }

  twitch_sandstorm_agent::template { 'lighthouse_key':
    destination => '/etc/lighthouse/lighthouse.sjc02.justin.tv.key',
    key         => "${key_prefix}/key",
    require     => File['/etc/lighthouse'],
  }
  twitch_sandstorm_agent::template { 'lighthouse_cert':
    destination => '/etc/lighthouse/lighthouse.sjc02.justin.tv.crt',
    key         => "${key_prefix}/cert",
    require     => File['/etc/lighthouse'],
  }
  twitch_sandstorm_agent::template { 'lighthouse_intermediate':
    destination => '/etc/lighthouse/lighthouse.sjc02.justin.tv.ca',
    key         => "${key_prefix}/intermediate",
    require     => File['/etc/lighthouse'],
  }
}
