# Twitch Diamond

Puppet module to install the diamond agent. Defaults to installing via pip provider.
All common collectors/handlers are specified in `$diamond_base_collectors` and
`$diamond_base_handlers`. To enable/disable more metrics simply add to hiera.


#### Example
```yaml
---
twitch_diamond::metrics:
  MemcachedCollector:
    enable: true
  CassandraRequestsCollector:
    enable: false
    source: true
    options:
      fqdn: '%{::fqdn}'
      ipaddress: '%{::ipaddress}'
  HttpdCollector:
    enable: true
    options:
      urls: 'changelog http://localhost/server-status?auto'

twitch_diamond::handlers:
  ExampleOneHandler:
    handler_name: 'diamond.handler.example.ExampleOneHandler'
    enable: true
  SampleTwoHandler:
    handler_name: 'diamond.handler.sample.SampleTwoHandler'
    enable: false
    options:
      url: 'http://localhost/do/something
  ThirdCustomHandler:
    handler_name: 'diamond.handler.third.ThirdCustomHandler'
    source: true
    enable: true
    options:
      url: 'http://localhost/do/something
  ForthCustomHandler:
    handler_name: 'diamond.handler.forth.ForthCustomHandler
    enable: true
    subsections:
    sub1:
      this: now
    sub2:
      that: later



# See here for a list of metrics you can filter or '' for all metrics
# https://github.com/python-diamond/Diamond/wiki/collectors-TCPCollector
twitch_diamond::tcp_metrics_filter: ''
```

