#!/usr/bin/python

import diamond.collector
import subprocess
import shutil
import os.path
import sys

oldstatdict = {}
newstatdict = {}

os.environ["http_proxy"] = ""


class CassandraRequestsCollector(diamond.collector.Collector):

    def get_default_config(self):
        """
        Returns the default collector settings
        """
        default_config = super(CassandraRequestsCollector,
                               self).get_default_config()
        default_config['fqdn'] = 'localhost'
        default_config['ipaddress'] = '127.0.0.1'
        return default_config

    def collect(self):

        read_metric_name = "cassandra.requests.reads_counter"
        write_metric_name = "cassandra.requests.writes_counter"

        (mainread, mainwrite) = CassandraRequestsCollector.getstats(self)
        self.publish_counter(read_metric_name, mainread)
        self.publish_counter(write_metric_name, mainwrite)
        return True

    def getstats(self):

        readcommand = '/usr/bin/curl http://' + self.config['ipaddress'] + ':8081/mbean?objectname=org.apache.cassandra.metrics%3Atype%3DClientRequest%2Cscope%3DRead%2Cname%3DLatency -s -H Host:' + self.config['fqdn'] + '|grep Count|cut -d">" -f8|cut -d"<" -f1'

        writecommand = '/usr/bin/curl http://' + self.config['ipaddress'] + ':8081/mbean?objectname=org.apache.cassandra.metrics%3Atype%3DClientRequest%2Cscope%3DWrite%2Cname%3DLatency -s -H Host:' + self.config['fqdn'] + '|grep Count|cut -d">" -f8|cut -d"<" -f1'

        writeps = subprocess.Popen(writecommand, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        writevalue = writeps.communicate()[0]

        readps = subprocess.Popen(readcommand, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
        readvalue = readps.communicate()[0]

        #casslog = open('/tmp/cass-stats-log', 'a')
        #casslog.write("write: " + str(writediff) + "\n")
        #casslog.write("read: " + str(readdiff) + "\n")
        #casslog.close()

        return (int(readvalue), int(writevalue))
