#!/usr/bin/env python

import diamond.collector
import shlex
import subprocess

class DNSSerialCollector(diamond.collector.Collector):
    def get_default_config(self):
        """
        Returns the default collector settings
        """
        config = super(DNSSerialCollector, self).get_default_config()
        config.update({
            'path': 'nsd',
        })
        return config

    def collect(self):
        # zone1, zone2, etc.
        zones = self.config.get('zones')
        port  = self.config.get('port')
        # Set Metric Name
        for z in zones:
            metric_name = "zones.{}.serial".format(z.replace(".", "_"))
            command = shlex.split("/usr/bin/dig -p {0} +retries=3 +timeout=3 +short @127.0.0.1 {1}. SOA".format(port, z))
            # ib-ins.prod.sfo01.justin.tv. admin.justin.tv. 2036935912 300 3600 604800 60
            dig_output = subprocess.check_output(command)
            SOA = dig_output.split(" ")[2]
            self.publish(metric_name, SOA)

