# coding=utf-8

"""
Collect stats from the number of go transcode processes on a system

#### Dependencies

    * collections.defaultdict or kitchen

"""
import diamond.collector
import psutil


class GoTranscoderCollector(diamond.collector.ProcessCollector):

    def get_default_config_help(self):
        config_help = super(GoTranscoderCollector, self).get_default_config_help()
        return config_help

    def get_default_config(self):
        """
        Returns the default collector settings
        """
        config = super(GoTranscoderCollector, self).get_default_config()
        config.update({
            'path':         'gotranscode',
        })
        return config

    def collect(self):
        count = len([x for x in psutil.process_iter() if 'gotranscoder' in x.name()])

        self.publish('count', count)
